#from . backup_set import *
from . constants import *
from . slices import sort_by_creation_time
import acrort
import sys

def create_backup_set_severity_calculator():
    severities = {
        BACKUP_SET_HOURLY: 1,
        BACKUP_SET_DAILY: 2,
        BACKUP_SET_WEEKLY: 3,
        BACKUP_SET_MONTHLY: 4,
        BACKUP_SET_INC: 1,
        BACKUP_SET_DIFF: 2,
        BACKUP_SET_FULL: 3
    }
    return (lambda backup_set: severities[backup_set])


def create_replication_predicate(rules, backup_set_calculator):
    has_nil_backup_set_rules = any([item.BackupSetIndex.is_data() and item.BackupSetIndex.type == acrort.plain.NIL for item in rules])
    if has_nil_backup_set_rules:
        return (lambda slice, pred: True)
    backup_set_rules = [item for item in rules if item.BackupSetIndex.is_data() and item.BackupSetIndex.type != acrort.plain.NIL]
    severity_calculator = create_backup_set_severity_calculator()
    min_backup_set_severity = min([severity_calculator(rule.BackupSetIndex.ref) for rule in rules])
    return (lambda slice, predecessor: severity_calculator(backup_set_calculator(slice, predecessor)) >= min_backup_set_severity)


def select_slices_to_replicate(source_slice_selector, target_slice_selector, replication_predicate):
    create_archive = False
    _, source_slices = source_slice_selector()
    if source_slices is None or len(source_slices) == 0:
        return create_archive, []
    source_slices = sort_by_creation_time(source_slices)

    _, target_slices = target_slice_selector()
    if target_slices is None:
        create_archive = True
        target_slices = []
    target_slices = sort_by_creation_time(target_slices)

    if len(target_slices) == 0:
        slices = [slice for slice, pred in zip(source_slices[1:], source_slices[:-1]) if replication_predicate(slice, pred)]
        return create_archive, [source_slices[0]] + slices

    last_replicated_target = max(target_slices, key=lambda s: s['creation_time'])
    last_replicated_source = [s for s in source_slices if s['id'] == last_replicated_target['id']]
    slices_to_replicate = []
    if last_replicated_source:
        last_replicated_source = last_replicated_source[0]
        non_replicated_tail = [slice for slice in source_slices if slice['creation_time'] > last_replicated_source['creation_time']]
        slices_and_predecessors = zip(non_replicated_tail, [last_replicated_source] + non_replicated_tail[:-1])
        slices_to_replicate = [slice for slice, pred in slices_and_predecessors if replication_predicate(slice, pred)]
    else:
        non_replicated_tail = [slice for slice in source_slices if slice['creation_time'] > last_replicated_target['creation_time']]
        if non_replicated_tail:
            if len(non_replicated_tail) == 1:
                slices_to_replicate = non_replicated_tail
            else:
                slices_and_predecessors = zip(non_replicated_tail[1:], non_replicated_tail[:-1])
                slices_to_replicate = [slice for slice, pred in slices_and_predecessors if replication_predicate(slice, pred)]
    
    return create_archive, slices_to_replicate
