import acrort

from . constants import *
from . request_tokens import *


def mkcred(*, user='', user_obscured=False, password='', password_obscured=False):
    opt = acrort.common.Credentials.CREDENTIALS_ENABLE_EMPTY
    if user_obscured:
        opt = opt | acrort.common.Credentials.CREDENTIALS_USERNAME_OBSCURED
    if password_obscured:
        opt = opt | acrort.common.Credentials.CREDENTIALS_PASSWORD_OBSCURED
    cred = acrort.common.Credentials(user, password, opt)
    return cred.to_unit()


class Stage:
    def __init__(self, *, location_type, use_plan_cred=True):
        self._result = {}
        self._result[ARG_LOCATION_TYPE] = location_type
        if use_plan_cred:
            self._result[ARG_STAGE_WITH_PLAN_CRED] = True
        else:
            self._result[ARG_STAGE_WITH_PLAN_CRED] = False
            self._result[ARG_LOCATION_CRED] = mkcred()

    def to_unit(self):
        return acrort.plain.Unit(self._result)


class StageToLocalFolder(Stage):
    def __init__(self, folder_path, archive_name):
        Stage.__init__(self, location_type=LOCAL_FOLDER_LOCATION)
        self._result[ARG_ARCHIVE_NAME] = archive_name
        self._result[ARG_LOCATION_URI] = folder_path
        self._result[ARG_LOCATION_URI_TYPE] = DESTINATION_LOCATION_URI_GLOBAL


class StageCentralizedToLocalPath(Stage):
    def __init__(self, local_path, archive_name):
        Stage.__init__(self, location_type=LOCAL_FOLDER_LOCATION)
        self._result[ARG_ARCHIVE_NAME] = archive_name
        self._result[ARG_LOCATION_URI] = local_path
        self._result[ARG_LOCATION_URI_TYPE] = DESTINATION_LOCATION_URI_LOCAL


class StageToASZ(Stage):
    def __init__(self, asz_uri, archive_name):
        Stage.__init__(self, location_type=ASZ_LOCATION, use_plan_cred=False)
        self._result[ARG_ARCHIVE_NAME] = archive_name
        self._result[ARG_LOCATION_URI] = asz_uri
        self._result[ARG_LOCATION_URI_TYPE] = DESTINATION_LOCATION_URI_GLOBAL

    def set_password(self, password, obscured=False):
        self._result[ARG_LOCATION_CRED] = mkcred(password=password, password_obscured=obscured)


class StageCentralizedToASZ(Stage):
    def __init__(self, archive_name):
        Stage.__init__(self, location_type=ASZ_LOCATION, use_plan_cred=False)
        self._result[ARG_ARCHIVE_NAME] = archive_name
        self._result[ARG_LOCATION_URI] = TAG_URI_ASZ
        self._result[ARG_LOCATION_URI_TYPE] = DESTINATION_LOCATION_URI_LOCAL

    def set_password(self, password, obscured=False):
        self._result[ARG_LOCATION_CRED] = mkcred(password=password, password_obscured=obscured)


class StageToOnline(Stage):
    def __init__(self, online_uri, archive_name, user, password):
        Stage.__init__(self, location_type=ONLINE_LOCATION, use_plan_cred=False)
        self._result[ARG_ARCHIVE_NAME] = archive_name
        self._result[ARG_LOCATION_URI] = online_uri
        self._result[ARG_LOCATION_URI_TYPE] = DESTINATION_LOCATION_URI_GLOBAL
        self._result[ARG_LOCATION_CRED] = mkcred(user=user, password=password)
