# @copyright (c) 2002-2013 Acronis International GmbH. All rights reserved.

from itertools import filterfalse
import heapq


def get_recursive(d, key, default=None):
    for token in (x for x in key.split('/') if x):
        d = isinstance(d, dict) and d.get(token, None) or None
        if d is None:
            return default
    return d


def replace_key(data, replacement):
    return {k: get_recursive(data, v or k) for k, v in replacement.items()}


def replace_key_recursive(data, replacement):
    return {replacement.get(k, k): (replace_key_recursive(v, replacement) if isinstance(v, dict) else v) for k, v in data.items()}


def extract_keys(data, *args):
    return {k: data[k] for k in args}


def first_of(items):
    for x in items:
        if x:
            return x


def get_sorted_unique2(values, op):
    unique = set(e[op] for v in values for e in v)
    return sorted(unique)


def select_unique(name, pool, mask='{}'):
    for i in range(1, len(pool) + 2):
        uname = name + mask.format(i)
        if uname not in pool:
            return uname


def count_of(iterable, flt=bool):
    return sum(bool(flt(x)) for x in iterable)


def dicts_xor_update(d1, d2):
    """from first will be removed all that not in second. from second removed all that in first"""
    keys = d1.keys() & d2.keys()
    for k in keys:
        d1[k] = d2[k]
        del d2[k]

    for k in d1.keys() - keys:
        del d1[k]


def for_each(items, fn):
    for x in items:
        fn(x)


def first(iterator):
    try:
        return next(iter(iterator))
    except StopIteration:
        return None


def unique(iterable, key=None):
    """List unique elements, preserving order. Remember all elements ever seen."""

    seen = set()
    seen_add = seen.add
    seen_contains = seen.__contains__

    if key is None:
        for element in filterfalse(seen_contains, iterable):
            seen_add(element)
            yield element
    else:
        for element in iterable:
            k = key(element)
            if k not in seen:
                seen.add(k)
                yield element


def heap_merge(*iterables, key=None):
    """ Merge sorted chains """
    if key is None:
        return heapq.merge(*iterables)
    else:
        iterables = (((key(x), x) for x in it) for it in iterables)
        return (x[1] for x in heapq.merge(*iterables))
