import acrort

from . command_ids import *
from . plan_construction import construct_plan


def deploy_plan(request, connection):
    plan = construct_plan(request, connection)
    activity_id = connection.tol.launch_command(command=PROTECT_COMMAND_ID, argument=plan)
    return connection.tol.get_result(activity_id)


def deploy_plan_remotely(request, connection):
    tol_argument = {'Script': {'Location': 'pyvfs:protect?deploy', 'Argument': request}}
    activity_id = connection.tol.launch_command(command=acrort.remoting.RUN_SCRIPT_COMMAND_ID_INFRA, argument=tol_argument)
    return connection.tol.get_result(activity_id)


def protect_now(request, connection):
    plan = construct_plan(request, connection)
    activity_id = connection.tol.launch_command(command=PROTECT_NOW_COMMAND_ID, argument=plan)
    return connection.tol.get_result(activity_id)


def protect_now_remotely(request, connection):
    tol_argument = {'Script': {'Location': 'pyvfs:protect?protect_now', 'Argument': request}}
    activity_id = connection.tol.launch_command(command=acrort.remoting.RUN_SCRIPT_COMMAND_ID_INFRA, argument=tol_argument)
    return connection.tol.get_result(activity_id)
